package gov.va.vamf.scheduling.direct.domain;

import com.agilex.healthcare.veteranappointment.domain.Namespace;
import org.springframework.data.mongodb.core.mapping.Document;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Document(collection="custom-messages")
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.DirectScheduling)
public class CustomMessage extends DomainBaseObject {

    @XmlElement
    private String siteCode;

    @XmlElement
    private String messageId;

    @XmlElement
    private String messageText;

    public String getSiteCode() {
        return siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getMessageId() {
        return messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageText() {
        return messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    @Override
    public String toString() {
        return String.format("Custom-Messsage[lastModifiedDate=%s, siteCode=%s, messageId=%s, messageText=%s]",
                getLastModifiedDate(), siteCode, messageId, messageText);
    }
}
